{ ------------------------------------------------------------------------ }
{  @@ Source Documentation                           *** TP6 Version ***   }
{                                                                          }
{  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   }
{                                                                          }
{   TITLE       : SBCBLST.PAS                                              }
{                                                                          }
{   DESCRIPTION :                                                          }
{       The program checks the BLASTER environment variable for the Card   }
{       settings. It also performs a test based on the BLASTER environment }
{       settings to ensure they tally with the hardware settings on the    }
{       Card.                                                              }
{ ------------------------------------------------------------------------ }

program sbcblst;

{ Include the SBC Unit, and any other units needed }
uses sbc_tp6;


{ ------------------------------------------------------------------------ }

{ main function }

const
    CardType: array[0..2] of string[18] = (
        'Sound Blaster',
        'Sound Blaster Pro',
        'Sound Blaster 2.0'
    );

var
    wFeature : word;

begin  { program body }

    if GetEnvSetting = 0 then begin

        wFeature := sbc_check_card;

        if wFeature <> 0 then begin

            if Boolean(sbc_test_int) then begin

                if sbc_test_dma >= 0 then begin

                    writeln(CardType[_wCardID-1],' card installed at :');
                    writeln('    Interrupt   : ', _ct_int_num);
                    writeln('    DMA Channel : ', _ct_dma_channel);
                    writeln;

                    if Boolean(wFeature and $0002) then
                        writeln('FM music available.');

                    if Boolean(wFeature and $0004) then
                        writeln('Creative voice available.');

                end
                else
                    writeln('Error on DMA channel.');
            end
            else
                writeln('Error on interrupt.');
        end
        else
            writeln('Sound Blaster card not found or wrong I/O setting.');
    end
    else
        writeln('BLASTER environment variable not set or incomplete or invalid.');
end.

